package io.github.cottonmc.cotton.gui.impl.mixin.client;

import io.github.cottonmc.cotton.gui.impl.client.ItemUseChecker;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

// Prevents LibGui screens from being opened in a dev environment
// using Item.use/useOnBlock/useOnEntity.
@Mixin(class_310.class)
abstract class MinecraftClientMixin {
	@Inject(method = "setScreen", at = @At("HEAD"))
	private void onSetScreen(class_437 screen, CallbackInfo info) {
		ItemUseChecker.checkSetScreen(screen);
	}
}
