/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.widget.WPanelWithInsets;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;

public class WGridPanel
extends WPanelWithInsets {
    private static final VisualLogger LOGGER = new VisualLogger(WGridPanel.class);
    protected int grid = 18;
    protected int horizontalGap = 0;
    protected int verticalGap = 0;

    public WGridPanel() {
    }

    public WGridPanel(int gridSize) {
        this.grid = gridSize;
    }

    public WGridPanel setGaps(int horizontalGap, int verticalGap) {
        if (!this.children.isEmpty()) {
            LOGGER.warn("You can only change gaps before adding children to a WGridPanel", new Object[0]);
            return this;
        }
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
        return this;
    }

    public void add(WWidget w, int x, int y) {
        this.add(w, x, y, 1, 1);
    }

    public void add(WWidget w, int x, int y, int width, int height) {
        this.children.add(w);
        w.parent = this;
        w.setLocation(x * (this.grid + this.horizontalGap) + this.insets.left(), y * (this.grid + this.verticalGap) + this.insets.top());
        if (w.canResize()) {
            w.setSize((width - 1) * (this.grid + this.horizontalGap) + this.grid, (height - 1) * (this.grid + this.verticalGap) + this.grid);
        }
        this.expandToFit(w, this.insets);
    }

    @Override
    public WGridPanel setInsets(Insets insets) {
        super.setInsets(insets);
        return this;
    }
}

