/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget.data;

import io.github.cottonmc.cotton.gui.widget.data.ObservableView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ObservableProperty<T>
implements ObservableView<T> {
    private static final String DEFAULT_NAME = "<unnamed>";
    private boolean hasValue;
    private T value;
    private final List<ObservableView.ChangeListener<? super T>> listeners = new ArrayList<ObservableView.ChangeListener<? super T>>();
    private final boolean allowNull;
    private final String name;

    private ObservableProperty(@Nullable T value, boolean hasValue, boolean allowNull, String name) {
        this.value = value;
        this.hasValue = hasValue;
        this.allowNull = allowNull;
        this.name = name;
        if (hasValue && value == null && !allowNull) {
            throw new NullPointerException("Cannot initialise nonnull property " + name + " with null value");
        }
    }

    public static <T> Builder<T> empty() {
        return new Builder<Object>(null, false);
    }

    public static <T> Builder<T> of(T initialValue) {
        return new Builder<T>(initialValue, true);
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public T get() {
        if (!this.hasValue) {
            throw new IllegalStateException("Property " + this.name + " not initialised!");
        }
        return this.value;
    }

    public void set(T value) {
        if (value == null && !this.allowNull) {
            throw new NullPointerException("Trying to set null value for nonnull property " + this.name);
        }
        T oldValue = this.value;
        this.value = value;
        this.hasValue = true;
        if (!Objects.equals(oldValue, value)) {
            for (ObservableView.ChangeListener<T> listener : this.listeners) {
                listener.onPropertyChange(this, oldValue, value);
            }
        }
    }

    public ObservableView<T> readOnly() {
        return new ObservableView<T>(){

            @Override
            public boolean hasValue() {
                return ObservableProperty.this.hasValue();
            }

            @Override
            public T get() {
                return ObservableProperty.this.get();
            }

            @Override
            public void addListener(ObservableView.ChangeListener<? super T> listener) {
                ObservableProperty.this.addListener(listener);
            }

            @Override
            public void removeListener(ObservableView.ChangeListener<? super T> listener) {
                ObservableProperty.this.removeListener(listener);
            }
        };
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(ObservableView.ChangeListener<? super T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableView.ChangeListener<? super T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    public static final class Builder<T> {
        private final T initialValue;
        private final boolean hasValue;
        private String name = "<unnamed>";
        private boolean allowNull = true;

        Builder(@Nullable T initialValue, boolean hasValue) {
            this.initialValue = initialValue;
            this.hasValue = hasValue;
        }

        public Builder<T> nonnull() {
            this.allowNull = false;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public ObservableProperty<T> build() {
            return new ObservableProperty<T>(this.initialValue, this.hasValue, this.allowNull, this.name);
        }
    }
}

