/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.networking;

import io.github.cottonmc.cotton.gui.networking.NetworkDirection;
import io.github.cottonmc.cotton.gui.networking.ScreenMessageKey;
import io.github.cottonmc.cotton.gui.widget.data.ObservableProperty;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface DataSlot<T> {
    public ObservableProperty<T> valueProperty();

    default public T get() {
        return this.valueProperty().get();
    }

    default public void set(T value) {
        this.valueProperty().set(value);
    }

    default public void addChangeListener(ChangeListener<T> listener) {
        this.valueProperty().addListener((property, from, to) -> listener.onValueChanged(this, from, to));
    }

    public ScreenMessageKey<T> getKey();

    public NetworkDirection getNetworkDirection();

    @FunctionalInterface
    public static interface ChangeListener<T> {
        public void onValueChanged(DataSlot<T> var1, T var2, T var3);
    }
}

