package io.github.cottonmc.cotton.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3954;
import io.github.cottonmc.cotton.gui.client.BackgroundPainter;
import io.github.cottonmc.cotton.gui.client.LibGui;
import io.github.cottonmc.cotton.gui.impl.DataSlotImpl;
import io.github.cottonmc.cotton.gui.impl.ScreenNetworkingImpl;
import io.github.cottonmc.cotton.gui.impl.mixin.ScreenHandlerAccessor;
import io.github.cottonmc.cotton.gui.networking.DataSlot;
import io.github.cottonmc.cotton.gui.networking.NetworkDirection;
import io.github.cottonmc.cotton.gui.networking.NetworkSide;
import io.github.cottonmc.cotton.gui.networking.ScreenMessageKey;
import io.github.cottonmc.cotton.gui.networking.ScreenNetworking;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlayerInvPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import io.github.cottonmc.cotton.gui.widget.data.Vec2i;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

/**
 * A screen handler-based GUI description for GUIs with slots.
 */
public class SyncedGuiDescription extends class_1703 implements GuiDescription {
	
	protected class_1263 blockInventory;
	protected class_1661 playerInventory;
	protected class_1937 world;
	protected class_3913 propertyDelegate;
	
	protected WPanel rootPanel = new WGridPanel().setInsets(Insets.ROOT_PANEL);
	protected int titleColor = WLabel.DEFAULT_TEXT_COLOR;
	protected int darkTitleColor = WLabel.DEFAULT_DARKMODE_TEXT_COLOR;
	protected boolean fullscreen = false;
	protected boolean titleVisible = true;
	protected HorizontalAlignment titleAlignment = HorizontalAlignment.LEFT;

	protected WWidget focus;
	private Vec2i titlePos = new Vec2i(8, 6);
	private boolean useDefaultRootBackground = true;

	private final ScreenNetworkingImpl networking;
	private final ScreenNetworkingImpl.DummyNetworking inactiveNetworking;
	private final List<DataSlotImpl<?>> dataSlots = new ArrayList<>();

	/**
	 * Constructs a new synced GUI description without a block inventory or a property delegate.
	 *
	 * @param type            the {@link class_3917} of this GUI description
	 * @param syncId          the current sync ID
	 * @param playerInventory the player inventory of the player viewing this screen
	 */
	public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory) {
		super(type, syncId);
		this.blockInventory = null;
		this.playerInventory = playerInventory;
		this.world = playerInventory.field_7546.method_73183();
		this.propertyDelegate = null;//new ArrayPropertyDelegate(1);
		this.networking = new ScreenNetworkingImpl(this, getNetworkSide());
		this.inactiveNetworking = new ScreenNetworkingImpl.DummyNetworking();
	}

	/**
	 * Constructs a new synced GUI description.
	 *
	 * @param type             the {@link class_3917} of this GUI description
	 * @param syncId           the current sync ID
	 * @param playerInventory  the player inventory of the player viewing this screen
	 * @param blockInventory   the block inventory of a corresponding container block, or null if not found or applicable
	 * @param propertyDelegate a property delegate whose properties, if any, will automatically be {@linkplain #method_17360(class_3913) added}
	 */
	public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory, @Nullable class_1263 blockInventory, @Nullable class_3913 propertyDelegate) {
		super(type, syncId);
		this.blockInventory = blockInventory;
		this.playerInventory = playerInventory;
		this.world = playerInventory.field_7546.method_73183();
		this.propertyDelegate = propertyDelegate;
		this.networking = new ScreenNetworkingImpl(this, getNetworkSide());
		this.inactiveNetworking = new ScreenNetworkingImpl.DummyNetworking();
		if (propertyDelegate!=null && propertyDelegate.method_17389()>0) this.method_17360(propertyDelegate);
		if (blockInventory != null) blockInventory.method_5435(playerInventory.field_7546);
	}
	
	public WPanel getRootPanel() {
		return rootPanel;
	}
	
	public int getTitleColor() {
		return (world.method_8608() && isDarkMode().orElse(LibGui.isDarkMode())) ? darkTitleColor : titleColor;
	}
	
	public SyncedGuiDescription setRootPanel(WPanel panel) {
		this.rootPanel = panel;
		return this;
	}

	@Override
	public SyncedGuiDescription setTitleColor(int color) {
		this.titleColor = color;
		this.darkTitleColor = (color == WLabel.DEFAULT_TEXT_COLOR) ? WLabel.DEFAULT_DARKMODE_TEXT_COLOR : color;
		return this;
	}

	@Override
	public SyncedGuiDescription setTitleColor(int lightColor, int darkColor) {
		this.titleColor = lightColor;
		this.darkTitleColor = darkColor;
		return this;
	}
	
	@Environment(EnvType.CLIENT)
	public void addPainters() {
		if (this.rootPanel!=null && !fullscreen && getUseDefaultRootBackground()) {
			this.rootPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
		}
	}

	@Override
	public boolean getUseDefaultRootBackground() {
		return useDefaultRootBackground;
	}

	@Override
	public void setUseDefaultRootBackground(boolean useDefaultRootBackground) {
		this.useDefaultRootBackground = useDefaultRootBackground;
	}

	public void addSlotPeer(ValidatedSlot slot) {
		this.method_7621(slot);
	}

	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 result = class_1799.field_8037;
		class_1735 slot = field_7761.get(index);

		if (slot.method_7681()) {
			class_1799 slotStack = slot.method_7677();
			result = slotStack.method_7972();

			if (blockInventory!=null) {
				if (slot.field_7871==blockInventory) {
					//Try to transfer the item from the block into the player's inventory
					if (!this.insertItem(slotStack, this.playerInventory, true, player)) {
						return class_1799.field_8037;
					}
				} else if (!this.insertItem(slotStack, this.blockInventory, false, player)) { //Try to transfer the item from the player to the block
					return class_1799.field_8037;
				}
			} else {
				//There's no block, just swap between the player's storage and their hotbar
				if (!swapHotbar(slotStack, index, this.playerInventory, player)) {
					return class_1799.field_8037;
				}
			}

			if (slotStack.method_7960()) {
				slot.method_53512(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}

		return result;
	}

	/** WILL MODIFY toInsert! Returns true if anything was inserted. */
	private boolean insertIntoExisting(class_1799 toInsert, class_1735 slot, class_1657 player) {
		class_1799 curSlotStack = slot.method_7677();
		if (!curSlotStack.method_7960() && class_1799.method_31577(toInsert, curSlotStack) && slot.method_7680(toInsert)) {
			int combinedAmount = curSlotStack.method_7947() + toInsert.method_7947();
			int maxAmount = Math.min(toInsert.method_7914(), slot.method_7676(toInsert));
			if (combinedAmount <= maxAmount) {
				toInsert.method_7939(0);
				curSlotStack.method_7939(combinedAmount);
				slot.method_7668();
				return true;
			} else if (curSlotStack.method_7947() < maxAmount) {
				toInsert.method_7934(maxAmount - curSlotStack.method_7947());
				curSlotStack.method_7939(maxAmount);
				slot.method_7668();
				return true;
			}
		}
		return false;
	}
	
	/** WILL MODIFY toInsert! Returns true if anything was inserted. */
	private boolean insertIntoEmpty(class_1799 toInsert, class_1735 slot) {
		class_1799 curSlotStack = slot.method_7677();
		if (curSlotStack.method_7960() && slot.method_7680(toInsert)) {
			if (toInsert.method_7947() > slot.method_7676(toInsert)) {
				slot.method_53512(toInsert.method_7971(slot.method_7676(toInsert)));
			} else {
				slot.method_53512(toInsert.method_7971(toInsert.method_7947()));
			}

			slot.method_7668();
			return true;
		}
		
		return false;
	}
	
	private boolean insertItem(class_1799 toInsert, class_1263 inventory, boolean walkBackwards, class_1657 player) {
		//Make a unified list of slots *only from this inventory*
		ArrayList<class_1735> inventorySlots = new ArrayList<>();
		for(class_1735 slot : field_7761) {
			if (slot.field_7871==inventory) inventorySlots.add(slot);
		}
		if (inventorySlots.isEmpty()) return false;
		
		//Try to insert it on top of existing stacks
		boolean inserted = false;
		if (walkBackwards) {
			for(int i=inventorySlots.size()-1; i>=0; i--) {
				class_1735 curSlot = inventorySlots.get(i);
				if (insertIntoExisting(toInsert, curSlot, player)) inserted = true;
				if (toInsert.method_7960()) break;
			}
		} else {
			for(int i=0; i<inventorySlots.size(); i++) {
				class_1735 curSlot = inventorySlots.get(i);
				if (insertIntoExisting(toInsert, curSlot, player)) inserted = true;
				if (toInsert.method_7960()) break;
			}
			
		}
		
		//If we still have any, shove them into empty slots
		if (!toInsert.method_7960()) {
			if (walkBackwards) {
				for(int i=inventorySlots.size()-1; i>=0; i--) {
					class_1735 curSlot = inventorySlots.get(i);
					if (insertIntoEmpty(toInsert, curSlot)) inserted = true;
					if (toInsert.method_7960()) break;
				}
			} else {
				for(int i=0; i<inventorySlots.size(); i++) {
					class_1735 curSlot = inventorySlots.get(i);
					if (insertIntoEmpty(toInsert, curSlot)) inserted = true;
					if (toInsert.method_7960()) break;
				}
				
			}
		}
		
		return inserted;
	}
	
	private boolean swapHotbar(class_1799 toInsert, int slotNumber, class_1263 inventory, class_1657 player) {
		//Feel out the slots to see what's storage versus hotbar
		ArrayList<class_1735> storageSlots = new ArrayList<>();
		ArrayList<class_1735> hotbarSlots = new ArrayList<>();
		boolean swapToStorage = true;
		boolean inserted = false;
		
		for(class_1735 slot : field_7761) {
			if (slot.field_7871 == inventory && slot instanceof ValidatedSlot validated) {
				int index = validated.getInventoryIndex();
				if (class_1661.method_7380(index)) {
					hotbarSlots.add(slot);
				} else {
					storageSlots.add(slot);
					if (slot.field_7874==slotNumber) swapToStorage = false;
				}
			}
		}
		if (storageSlots.isEmpty() || hotbarSlots.isEmpty()) return false;
		
		if (swapToStorage) {
			//swap from hotbar to storage
			for(int i=0; i<storageSlots.size(); i++) {
				class_1735 curSlot = storageSlots.get(i);
				if (insertIntoExisting(toInsert, curSlot, player)) inserted = true;
				if (toInsert.method_7960()) break;
			}
			if (!toInsert.method_7960()) {
				for(int i=0; i<storageSlots.size(); i++) {
					class_1735 curSlot = storageSlots.get(i);
					if (insertIntoEmpty(toInsert, curSlot)) inserted = true;
					if (toInsert.method_7960()) break;
				}
			}
		} else {
			//swap from storage to hotbar
			for(int i=0; i<hotbarSlots.size(); i++) {
				class_1735 curSlot = hotbarSlots.get(i);
				if (insertIntoExisting(toInsert, curSlot, player)) inserted = true;
				if (toInsert.method_7960()) break;
			}
			if (!toInsert.method_7960()) {
				for(int i=0; i<hotbarSlots.size(); i++) {
					class_1735 curSlot = hotbarSlots.get(i);
					if (insertIntoEmpty(toInsert, curSlot)) inserted = true;
					if (toInsert.method_7960()) break;
				}
			}
		}
		
		return inserted;
	}

	@Nullable
	@Override
	public class_3913 getPropertyDelegate() {
		return propertyDelegate;
	}
	
	@Override
	public GuiDescription setPropertyDelegate(class_3913 delegate) {
		this.propertyDelegate = delegate;
		return this;
	}

	/**
	 * Creates a player inventory widget from this panel's {@linkplain #playerInventory player inventory}.
	 *
	 * @return the created inventory widget
	 */
	public WPlayerInvPanel createPlayerInventoryPanel() {
		return new WPlayerInvPanel(this.playerInventory);
	}

	/**
	 * Creates a player inventory widget from this panel's {@linkplain #playerInventory player inventory}.
	 *
	 * @param hasLabel whether the "Inventory" label should be displayed
	 * @return the created inventory widget
	 * @since 2.0.0
	 */
	public WPlayerInvPanel createPlayerInventoryPanel(boolean hasLabel) {
		return new WPlayerInvPanel(this.playerInventory, hasLabel);
	}

	/**
	 * Creates a player inventory widget from this panel's {@linkplain #playerInventory player inventory}.
	 *
	 * @param label the inventory label widget
	 * @return the created inventory widget
	 * @since 2.0.0
	 */
	public WPlayerInvPanel createPlayerInventoryPanel(WWidget label) {
		return new WPlayerInvPanel(this.playerInventory, label);
	}

	/**
	 * Gets the block inventory at the context.
	 *
	 * <p>If no inventory is found, returns {@link EmptyInventory#INSTANCE}.
	 *
	 * <p>Searches for these implementations in the following order:
	 * <ol>
	 *     <li>Blocks implementing {@code InventoryProvider}</li>
	 *     <li>Block entities implementing {@code InventoryProvider}</li>
	 *     <li>Block entities implementing {@code Inventory}</li>
	 * </ol>
	 *
	 * @param ctx the context
	 * @return the found inventory
	 */
	public static class_1263 getBlockInventory(class_3914 ctx) {
		return getBlockInventory(ctx, () -> EmptyInventory.INSTANCE);
	}

	/**
	 * Gets the block inventory at the context.
	 *
	 * <p>If no inventory is found, returns a simple mutable inventory
	 * with the specified number of slots.
	 *
	 * <p>Searches for these implementations in the following order:
	 * <ol>
	 *     <li>Blocks implementing {@code InventoryProvider}</li>
	 *     <li>Block entities implementing {@code InventoryProvider}</li>
	 *     <li>Block entities implementing {@code Inventory}</li>
	 * </ol>
	 *
	 * @param ctx  the context
	 * @param size the fallback inventory size
	 * @return the found inventory
	 * @since 2.0.0
	 */
	public static class_1263 getBlockInventory(class_3914 ctx, int size) {
		return getBlockInventory(ctx, () -> new class_1277(size));
	}

	private static class_1263 getBlockInventory(class_3914 ctx, Supplier<class_1263> fallback) {
		return ctx.method_17395((world, pos) -> {
			class_2680 state = world.method_8320(pos);
			class_2248 b = state.method_26204();

			if (b instanceof class_3954 inventoryProvider) {
				class_1263 inventory = inventoryProvider.method_17680(state, world, pos);
				if (inventory != null) {
					return inventory;
				}
			}

			class_2586 be = world.method_8321(pos);
			if (be!=null) {
				if (be instanceof class_3954 inventoryProvider) {
					class_1263 inventory = inventoryProvider.method_17680(state, world, pos);
					if (inventory != null) {
						return inventory;
					}
				} else if (be instanceof class_1263 inventory) {
					return inventory;
				}
			}

			return fallback.get();
		}).orElseGet(fallback);
	}

	/**
	 * Gets the property delegate at the context.
	 *
	 * <p>If no property delegate is found, returns an empty property delegate with no properties.
	 *
	 * <p>Searches for block entities implementing {@link PropertyDelegateHolder}.
	 *
	 * @param ctx the context
	 * @return the found property delegate
	 */
	public static class_3913 getBlockPropertyDelegate(class_3914 ctx) {
		return ctx.method_17395((world, pos) -> {
			class_2586 be = world.method_8321(pos);
			if (be instanceof PropertyDelegateHolder holder) {
				return holder.getPropertyDelegate();
			}
			
			return new class_3919(0);
		}).orElse(new class_3919(0));
	}

	/**
	 * Gets the property delegate at the context.
	 *
	 * <p>If no property delegate is found, returns an array property delegate
	 * with the specified number of properties.
	 *
	 * <p>Searches for block entities implementing {@link PropertyDelegateHolder}.
	 *
	 * @param ctx  the context
	 * @param size the number of properties
	 * @return the found property delegate
	 * @since 2.0.0
	 */
	public static class_3913 getBlockPropertyDelegate(class_3914 ctx, int size) {
		return ctx.method_17395((world, pos) -> {
			class_2586 be = world.method_8321(pos);
			if (be instanceof PropertyDelegateHolder holder) {
				return holder.getPropertyDelegate();
			}

			return new class_3919(size);
		}).orElse(new class_3919(size));
	}
	
	//extends ScreenHandler {
		@Override
		public boolean method_7597(class_1657 entity) {
			return (blockInventory!=null) ? blockInventory.method_5443(entity) : true;
		}

		@Override
		public void method_7595(class_1657 player) {
			super.method_7595(player);
			if (blockInventory != null) blockInventory.method_5432(player);
		}

		@Override
		public void method_7623() {
			super.method_7623();
			sendDataSlotUpdates();
		}
	//}

	@Override
	public boolean isFocused(WWidget widget) {
		return focus == widget;
	}

	@Override
	public WWidget getFocus() {
		return focus;
	}

	@Override
	public void requestFocus(WWidget widget) {
		//TODO: Are there circumstances where focus can't be stolen?
		if (focus==widget) return; //Nothing happens if we're already focused
		if (!widget.canFocus()) return; //This is kind of a gotcha but needs to happen
		if (focus!=null) focus.onFocusLost();
		focus = widget;
		focus.onFocusGained();
	}

	@Override
	public void releaseFocus(WWidget widget) {
		if (focus==widget) {
			focus = null;
			widget.onFocusLost();
		}
	}

	@Override
	public boolean isFullscreen() {
		return fullscreen;
	}

	@Override
	public void setFullscreen(boolean fullscreen) {
		this.fullscreen = fullscreen;
	}

	@Override
	public boolean isTitleVisible() {
		return titleVisible;
	}

	@Override
	public void setTitleVisible(boolean titleVisible) {
		this.titleVisible = titleVisible;
	}

	@Override
	public HorizontalAlignment getTitleAlignment() {
		return titleAlignment;
	}

	@Override
	public void setTitleAlignment(HorizontalAlignment titleAlignment) {
		this.titleAlignment = titleAlignment;
	}

	@Override
	public Vec2i getTitlePos() {
		return titlePos;
	}

	@Override
	public void setTitlePos(Vec2i titlePos) {
		this.titlePos = titlePos;
	}

	/**
	 * {@return the world of this GUI description's player}
	 * @since 10.0.0
	 */
	public class_1937 getWorld() {
		return world;
	}

	/**
	 * Gets the network side this GUI description runs on.
	 *
	 * @return this GUI's network side
	 * @since 3.3.0
	 */
	public final NetworkSide getNetworkSide() {
		return world instanceof class_3218 ? NetworkSide.SERVER : NetworkSide.CLIENT;
	}

	/**
	 * Gets the packet sender corresponding to this GUI's network side.
	 *
	 * @return the packet sender
	 * @since 3.3.0
	 */
	public final PacketSender getPacketSender() {
		if (getNetworkSide() == NetworkSide.SERVER) {
			return ServerPlayNetworking.getSender((class_3222) playerInventory.field_7546);
		} else {
			return getClientPacketSender();
		}
	}

	@Environment(EnvType.CLIENT)
	private PacketSender getClientPacketSender() {
		return ClientPlayNetworking.getSender();
	}

	/**
	 * Gets a networking handler for the GUI description that is active on the specified side.
	 *
	 * <p>If the network side doesn't match the {@linkplain #getNetworkSide() side of this GUI},
	 * returns a no-op networking handler that is still safe to use.
	 *
	 * @param side the network side, cannot be null
	 * @return the networking handler corresponding to the side
	 * @since 13.1.0
	 */
	public final ScreenNetworking getNetworking(NetworkSide side) {
		Objects.requireNonNull(side, "side");
		return side == getNetworkSide() ? networking : inactiveNetworking;
	}

	/**
	 * Registers a data slot.
	 *
	 * <p>This method must be called on both network sides in order for the data slot
	 * to sync properly.
	 *
	 * <p>The initial value of a data slot will not be synced.
	 *
	 * <p>For S2C item stack and int data slots, you should usually use
	 * {@linkplain class_1735 vanilla}/{@linkplain io.github.cottonmc.cotton.gui.widget.WItemSlot LibGui}
	 * slots and {@linkplain class_3913 property delegates}, respectively.
	 *
	 * @param key              the key of the sync message, cannot be null
	 * @param initialValue     the initial value of the data slot
	 * @param networkDirection the network direction to sync, cannot be null
	 * @return the data slot
	 * @param <T> the data slot content type
	 * @since 13.1.0
	 */
	public <T> DataSlot<T> registerDataSlot(ScreenMessageKey<T> key, T initialValue, NetworkDirection networkDirection) {
		Objects.requireNonNull(key, "key");
		Objects.requireNonNull(networkDirection, "networkDirection");
		var slot = new DataSlotImpl<>(this, key, initialValue, networkDirection);
		getNetworking(networkDirection.to()).receive(key, slot::set);
		dataSlots.add(slot);
		return slot;
	}

	/**
	 * Registers an S2C data slot.
	 *
	 * <p>This method must be called on both network sides in order for the data slot
	 * to sync properly.
	 *
	 * <p>The initial value of a data slot will not be synced.
	 *
	 * <p>For item stack and int data slots, you should usually use
	 * {@linkplain class_1735 vanilla}/{@linkplain io.github.cottonmc.cotton.gui.widget.WItemSlot LibGui}
	 * slots and {@linkplain class_3913 property delegates}, respectively.
	 *
	 * @param key          the key of the sync message, cannot be null
	 * @param initialValue the initial value of the data slot
	 * @return the data slot
	 * @param <T> the data slot content type
	 * @since 13.1.0
	 */
	public <T> DataSlot<T> registerDataSlot(ScreenMessageKey<T> key, T initialValue) {
		return registerDataSlot(key, initialValue, NetworkDirection.SERVER_TO_CLIENT);
	}

	/**
	 * Checks for and sends data slot content updates.
	 *
	 * <p>This method is generally called automatically.
	 * If you need to manually sync data slots from the server to the client,
	 * prefer {@link #method_7623()}.
	 *
	 * @since 13.1.0
	 */
	public void sendDataSlotUpdates() {
		if (!((ScreenHandlerAccessor) this).libgui$getDisableSync() && networking.isReady()) {
			NetworkSide side = getNetworkSide();
			for (DataSlotImpl<?> dataSlot : dataSlots) {
				if (side == dataSlot.getNetworkDirection().from()) {
					dataSlot.checkAndSendUpdate();
				}
			}
		}
	}
}
