package io.github.cottonmc.cotton.gui.impl.client;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

/**
 * Crashes the game if a LibGui screen is opened in {@code Item.use/useOnBlock/useOnEntity}.
 */
public final class ItemUseChecker {
	// Setting this property to "true" disables the check.
	private static final String ALLOW_ITEM_USE_PROPERTY = "libgui.allowItemUse";

	// Stack walker instance used to check the caller.
	private static final StackWalker STACK_WALKER =
			StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

	// List of banned item use methods.
	private static final List<class_3545<String, MethodType>> ITEM_USE_METHODS = class_156.method_654(new ArrayList<>(), result -> {
		MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();

		String hand = "class_1268";
		String actionResult = "class_1269";
		String livingEntity = "class_1309";
		String playerEntity = "class_1657";
		String itemStack = "class_1799";
		String itemUsageContext = "class_1838";
		String world = "class_1937";

		// use
		result.add(resolveItemMethod(resolver, "method_7836", actionResult, world, playerEntity, hand));
		// useOnBlock
		result.add(resolveItemMethod(resolver, "method_7884", actionResult, itemUsageContext));
		// useOnEntity
		result.add(resolveItemMethod(resolver, "method_7847", actionResult, itemStack, playerEntity, livingEntity, hand));
	});

	private static class_3545<String, MethodType> resolveItemMethod(MappingResolver resolver, String name, String returnType, String... parameterTypes) {
		// Build intermediary descriptor for resolving the method in the mappings.
		StringBuilder desc = new StringBuilder("(");
		for (String type : parameterTypes) {
			desc.append("Lnet/minecraft/").append(type).append(';');
		}
		desc.append(")Lnet/minecraft/").append(returnType).append(';');

		// Remap the method name.
		String deobfName = resolver.mapMethodName("intermediary", "net.minecraft.class_1792", name, desc.toString());

		// Remap the descriptor types.
		Function<String, Class<?>> getIntermediaryClass = className -> {
			className = resolver.mapClassName("intermediary", "net.minecraft." + className);

			try {
				return Class.forName(className);
			} catch (ClassNotFoundException e) {
				throw new RuntimeException("Could not resolve class net.minecraft." + className, e);
			}
		};
		Class<?>[] paramClasses = Arrays.stream(parameterTypes)
				.map(getIntermediaryClass)
				.toArray(Class[]::new);
		Class<?> returnClass = getIntermediaryClass.apply(returnType);

		// Check that the method actually exists.
		try {
			class_1792.class.getMethod(deobfName, paramClasses);
		} catch (NoSuchMethodException e) {
			throw new RuntimeException("Could not find Item method " + deobfName, e);
		}

		return new class_3545<>(deobfName, MethodType.methodType(returnClass, paramClasses));
	}

	/**
	 * Checks whether the specified screen is a LibGui screen opened
	 * from an item usage method.
	 *
	 * @throws class_148 if opening the screen is not allowed
	 */
	public static void checkSetScreen(class_437 screen) {
		if (!(screen instanceof CottonScreenImpl cs) || Boolean.getBoolean(ALLOW_ITEM_USE_PROPERTY)) return;

		// Check if this is called via Item.use. If so, crash the game.

		// The calling variant of Item.use[OnBlock|OnEntity].
		// If null, nothing bad happened.
		@Nullable class_3545<? extends Class<?>, String> useMethodCaller = STACK_WALKER.walk(s -> s
						.skip(3) // checkSetScreen, setScreen injection, setScreen
						.flatMap(frame -> {
							if (!class_1792.class.isAssignableFrom(frame.getDeclaringClass())) return Stream.empty();

							return ITEM_USE_METHODS.stream()
									.filter(method -> method.method_15442().equals(frame.getMethodName()) &&
											method.method_15441().equals(frame.getMethodType()))
									.map(method -> new class_3545<>(frame.getDeclaringClass(), method.method_15442()));
						})
						.findFirst())
				.orElse(null);

		if (useMethodCaller != null) {
			String message = """
						[LibGui] Screens cannot be opened in item use methods. Some alternatives include:
							- Using a packet together with LightweightGuiDescription
							- Using an ItemSyncedGuiDescription
						Setting the screen in item use methods leads to threading issues and
						other potential crashes on both the client and the server.
						If you want to disable this check, set the system property %s to "true"."""
					.formatted(ALLOW_ITEM_USE_PROPERTY);
			var cause = new UnsupportedOperationException(message);
			cause.fillInStackTrace();
			class_128 report = class_128.method_560(cause, "Opening screen");
			report.method_562("Screen opening details")
					.method_578("Screen class", screen.getClass().getName())
					.method_577("GUI description", () -> cs.getDescription().getClass().getName())
					.method_577("Item class", () -> useMethodCaller.method_15442().getName())
					.method_578("Involved method", useMethodCaller.method_15441());
			throw new class_148(report);
		}
	}
}
