package io.github.cottonmc.cotton.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5481;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * A builder for widget tooltips.
 *
 * @since 3.0.0
 */
@Environment(EnvType.CLIENT)
public final class TooltipBuilder {
	final List<class_5481> lines = new ArrayList<>();

	int size() {
		return lines.size();
	}

	/**
	 * Adds the lines to this builder.
	 *
	 * @param lines the lines
	 * @return this builder
	 */
	public TooltipBuilder add(class_2561... lines) {
		for (class_2561 line : lines) {
			this.lines.add(line.method_30937());
		}

		return this;
	}

	/**
	 * Adds the lines to this builder.
	 *
	 * @param lines the lines
	 * @return this builder
	 */
	public TooltipBuilder add(class_5481... lines) {
		Collections.addAll(this.lines, lines);

		return this;
	}
}
