/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.client;

import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record WidgetHudElement(WWidget widget, @Nullable Positioner positioner) implements HudElement
{
    @ApiStatus.Internal
    static final Set<WWidget> tickingWidgets = new HashSet<WWidget>();

    public WidgetHudElement(WWidget widget) {
        this(widget, null);
    }

    public WidgetHudElement(WWidget widget, int x, int y) {
        this(widget, Positioner.of(x, y));
    }

    public WidgetHudElement(WWidget widget, Positioner positioner, int width, int height) {
        this(widget, positioner);
        widget.setSize(width, height);
    }

    public WidgetHudElement(WWidget widget, int x, int y, int width, int height) {
        this(widget, Positioner.of(x, y), width, height);
    }

    public void enableTicking() {
        tickingWidgets.add(this.widget);
    }

    public void disableTicking() {
        tickingWidgets.remove(this.widget);
    }

    public void render(class_332 context, class_9779 tickCounter) {
        WidgetHudElement.render(context, this.widget, this.positioner);
    }

    @ApiStatus.Internal
    static void render(class_332 context, WWidget widget, @Nullable Positioner positioner) {
        class_1041 window = class_310.method_1551().method_22683();
        int hudWidth = window.method_4486();
        int hudHeight = window.method_4502();
        if (positioner != null) {
            positioner.reposition(widget, hudWidth, hudHeight);
        }
        widget.paint(context, widget.getX(), widget.getY(), -1, -1);
    }

    static {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (WWidget widget : tickingWidgets) {
                widget.tick();
            }
        });
    }

    @FunctionalInterface
    public static interface Positioner {
        public void reposition(WWidget var1, int var2, int var3);

        public static Positioner of(int x, int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth + x) % hudWidth, (hudHeight + y) % hudHeight);
        }

        public static Positioner horizontallyCentered(int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth - widget.getWidth()) / 2, (hudHeight + y) % hudHeight);
        }
    }
}

