/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.ObservableProperty;
import java.util.function.Function;
import net.minecraft.class_11909;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class MouseInputHandler<S extends class_437> {
    private final S screen;
    private final ObservableProperty<@Nullable WWidget> hovered = ObservableProperty.of(null).build();
    private boolean clickDoubled;

    public MouseInputHandler(S screen) {
        this.screen = screen;
        this.hovered.addListener((property, from, to) -> {
            if (from != null) {
                from.setHovered(false);
            }
            if (to != null) {
                to.setHovered(true);
            }
        });
    }

    public void onMouseDown(int containerX, int containerY, class_11909 click, boolean doubled) {
        this.clickDoubled = doubled;
        if (((CottonScreenImpl)this.screen).getLastResponder() == null) {
            WWidget lastResponder = ((CottonScreenImpl)this.screen).getDescription().getRootPanel().hit(containerX, containerY);
            ((CottonScreenImpl)this.screen).setLastResponder(lastResponder);
            if (lastResponder != null) {
                MouseInputHandler.runTree(lastResponder, widget -> widget.onMouseDown(MouseInputHandler.clickAt(click, containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY()), doubled));
            }
        }
    }

    public void onMouseUp(int containerX, int containerY, class_11909 click) {
        WWidget lastResponder = ((CottonScreenImpl)this.screen).getLastResponder();
        if (lastResponder != null) {
            int width = ((class_437)this.screen).field_22789;
            int height = ((class_437)this.screen).field_22790;
            MouseInputHandler.runTree(lastResponder, widget -> widget.onMouseUp(MouseInputHandler.clickAt(click, containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY())));
            if (containerX >= 0 && containerY >= 0 && containerX < width && containerY < height) {
                MouseInputHandler.runTree(lastResponder, widget -> widget.onClick(MouseInputHandler.clickAt(click, containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY()), this.clickDoubled));
            }
        } else {
            MouseInputHandler.runTree(((CottonScreenImpl)this.screen).getDescription().getRootPanel().hit(containerX, containerY), widget -> widget.onMouseUp(MouseInputHandler.clickAt(click, containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY())));
        }
        ((CottonScreenImpl)this.screen).setLastResponder(null);
    }

    public void onMouseDrag(int containerX, int containerY, class_11909 click, double offsetX, double offsetY) {
        WWidget lastResponder = ((CottonScreenImpl)this.screen).getLastResponder();
        if (lastResponder != null) {
            lastResponder.onMouseDrag(MouseInputHandler.clickAt(click, containerX - lastResponder.getAbsoluteX(), containerY - lastResponder.getAbsoluteY()), offsetX, offsetY);
        } else {
            int width = ((class_437)this.screen).field_22789;
            int height = ((class_437)this.screen).field_22790;
            if (containerX < 0 || containerY < 0 || containerX >= width || containerY >= height) {
                return;
            }
            MouseInputHandler.runTree(((CottonScreenImpl)this.screen).getDescription().getRootPanel().hit(containerX, containerY), widget -> widget.onMouseDrag(MouseInputHandler.clickAt(click, containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY()), offsetX, offsetY));
        }
    }

    public void onMouseScroll(int containerX, int containerY, double horizontalAmount, double verticalAmount) {
        MouseInputHandler.runTree(((CottonScreenImpl)this.screen).getDescription().getRootPanel().hit(containerX, containerY), widget -> widget.onMouseScroll(containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY(), horizontalAmount, verticalAmount));
    }

    public void onMouseMove(int containerX, int containerY) {
        WWidget hit = ((CottonScreenImpl)this.screen).getDescription().getRootPanel().hit(containerX, containerY);
        MouseInputHandler.runTree(hit, widget -> widget.onMouseMove(containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY()));
        @Nullable WWidget hoveredWidget = MouseInputHandler.runTree(hit, widget -> InputResult.of(widget.canHover() && widget.isWithinBounds(containerX - widget.getAbsoluteX(), containerY - widget.getAbsoluteY())));
        this.hovered.set(hoveredWidget);
    }

    @Nullable
    private static WWidget runTree(WWidget bottom, Function<WWidget, InputResult> function) {
        InputResult result;
        WWidget current;
        for (current = bottom; current != null && (result = function.apply(current)) != InputResult.PROCESSED; current = current.getParent()) {
        }
        return current;
    }

    public void checkFocus(int mouseX, int mouseY) {
        int wy;
        int wx;
        WWidget focus = ((CottonScreenImpl)this.screen).getDescription().getFocus();
        if (focus != null && !focus.isWithinBounds(mouseX - (wx = focus.getAbsoluteX()), mouseY - (wy = focus.getAbsoluteY()))) {
            ((CottonScreenImpl)this.screen).getDescription().releaseFocus(focus);
        }
    }

    public static class_11909 clickAt(class_11909 click, double x, double y) {
        return new class_11909(x, y, click.comp_4800());
    }
}

