/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.TextAlignment;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

public class WDynamicLabel
extends WWidget {
    protected Supplier<String> text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected int color;
    protected int darkmodeColor;
    protected boolean drawShadows;
    public static final int DEFAULT_TEXT_COLOR = -12566464;
    public static final int DEFAULT_DARKMODE_TEXT_COLOR = -4408132;

    public WDynamicLabel(Supplier<String> text, int color) {
        this.text = text;
        this.color = color;
        this.darkmodeColor = color == -12566464 ? -4408132 : color;
    }

    public WDynamicLabel(Supplier<String> text) {
        this(text, -12566464);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, 1);
        String tr = this.text.get();
        if (this.getDrawShadows()) {
            ScreenDrawing.drawStringWithShadow(context, tr, this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        } else {
            ScreenDrawing.drawString(context, tr, this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, 20);
    }

    public WDynamicLabel setDarkmodeColor(int color) {
        this.darkmodeColor = color;
        return this;
    }

    public WDynamicLabel disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public WDynamicLabel setColor(int color, int darkmodeColor) {
        this.color = color;
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public boolean getDrawShadows() {
        return this.drawShadows;
    }

    public WDynamicLabel setDrawShadows(boolean drawShadows) {
        this.drawShadows = drawShadows;
        return this;
    }

    public WDynamicLabel setText(Supplier<String> text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WDynamicLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WDynamicLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }
}

