/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.impl.client;

import io.github.cottonmc.cotton.gui.impl.client.CottonScreenImpl;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class ItemUseChecker {
    private static final String ALLOW_ITEM_USE_PROPERTY = "libgui.allowItemUse";
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final List<class_3545<String, MethodType>> ITEM_USE_METHODS = (List)class_156.method_654(new ArrayList(), result -> {
        MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
        String hand = "class_1268";
        String actionResult = "class_1269";
        String livingEntity = "class_1309";
        String playerEntity = "class_1657";
        String itemStack = "class_1799";
        String itemUsageContext = "class_1838";
        String world = "class_1937";
        result.add(ItemUseChecker.resolveItemMethod(resolver, "method_7836", actionResult, world, playerEntity, hand));
        result.add(ItemUseChecker.resolveItemMethod(resolver, "method_7884", actionResult, itemUsageContext));
        result.add(ItemUseChecker.resolveItemMethod(resolver, "method_7847", actionResult, itemStack, playerEntity, livingEntity, hand));
    });

    private static class_3545<String, MethodType> resolveItemMethod(MappingResolver resolver, String name, String returnType, String ... parameterTypes) {
        StringBuilder desc = new StringBuilder("(");
        for (String type : parameterTypes) {
            desc.append("Lnet/minecraft/").append(type).append(';');
        }
        desc.append(")Lnet/minecraft/").append(returnType).append(';');
        String deobfName = resolver.mapMethodName("intermediary", "net.minecraft.class_1792", name, desc.toString());
        Function<String, Class> getIntermediaryClass = className -> {
            className = resolver.mapClassName("intermediary", "net.minecraft." + className);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not resolve class net.minecraft." + className, e);
            }
        };
        Class[] paramClasses = (Class[])Arrays.stream(parameterTypes).map(getIntermediaryClass).toArray(Class[]::new);
        Class returnClass = getIntermediaryClass.apply(returnType);
        try {
            class_1792.class.getMethod(deobfName, paramClasses);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find Item method " + deobfName, e);
        }
        return new class_3545((Object)deobfName, (Object)MethodType.methodType(returnClass, paramClasses));
    }

    public static void checkSetScreen(class_437 screen) {
        CottonScreenImpl cs;
        block5: {
            block4: {
                if (!(screen instanceof CottonScreenImpl)) break block4;
                cs = (CottonScreenImpl)screen;
                if (!Boolean.getBoolean(ALLOW_ITEM_USE_PROPERTY)) break block5;
            }
            return;
        }
        @Nullable class_3545 useMethodCaller = STACK_WALKER.walk(s -> s.skip(3L).flatMap(frame -> {
            if (!class_1792.class.isAssignableFrom(frame.getDeclaringClass())) {
                return Stream.empty();
            }
            return ITEM_USE_METHODS.stream().filter(method -> ((String)method.method_15442()).equals(frame.getMethodName()) && ((MethodType)method.method_15441()).equals((Object)frame.getMethodType())).map(method -> new class_3545(frame.getDeclaringClass(), (Object)((String)method.method_15442())));
        }).findFirst()).orElse(null);
        if (useMethodCaller != null) {
            String message = "[LibGui] Screens cannot be opened in item use methods. Some alternatives include:\n\t- Using a packet together with LightweightGuiDescription\n\t- Using an ItemSyncedGuiDescription\nSetting the screen in item use methods leads to threading issues and\nother potential crashes on both the client and the server.\nIf you want to disable this check, set the system property %s to \"true\".".formatted(ALLOW_ITEM_USE_PROPERTY);
            UnsupportedOperationException cause = new UnsupportedOperationException(message);
            cause.fillInStackTrace();
            class_128 report = class_128.method_560((Throwable)cause, (String)"Opening screen");
            report.method_562("Screen opening details").method_578("Screen class", (Object)screen.getClass().getName()).method_577("GUI description", () -> cs.getDescription().getClass().getName()).method_577("Item class", () -> ((Class)useMethodCaller.method_15442()).getName()).method_578("Involved method", useMethodCaller.method_15441());
            throw new class_148(report);
        }
    }
}

