/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget.focus;

import io.github.cottonmc.cotton.gui.widget.data.Rect2i;
import io.github.cottonmc.cotton.gui.widget.focus.Focus;
import io.github.cottonmc.cotton.gui.widget.focus.FocusModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class SimpleKeyedFocusModel<K>
implements FocusModel<K> {
    private final List<Focus<K>> foci;
    @Nullable
    private K focused;

    public SimpleKeyedFocusModel(List<Focus<K>> foci) {
        this.foci = Objects.requireNonNull(foci, "foci");
        HashSet<K> keys = new HashSet<K>();
        for (Focus<K> focus : foci) {
            if (keys.add(focus.key())) continue;
            throw new IllegalArgumentException("Duplicate focus key: " + String.valueOf(focus.key()));
        }
    }

    @Nullable
    public K getFocusedKey() {
        return this.focused;
    }

    @Override
    public boolean isFocused(Focus<K> focus) {
        return Objects.equals(focus.key(), this.focused);
    }

    @Override
    public void setFocused(Focus<K> focus) {
        this.focused = focus.key();
    }

    @Override
    public Stream<Focus<K>> foci() {
        return this.foci.stream();
    }

    @Contract(value="-> new")
    public static <K> Builder<K> builder() {
        return new Builder();
    }

    public static final class Builder<K> {
        private final List<Focus<K>> foci = new ArrayList<Focus<K>>();

        private Builder() {
        }

        @Contract(value="null -> fail; _ -> this")
        public Builder<K> add(Focus<K> focus) {
            Objects.requireNonNull(focus, "Focus cannot be null");
            this.foci.add(focus);
            return this;
        }

        @Contract(value="_, null -> fail; _, _ -> this")
        public Builder<K> add(K key, Rect2i area) {
            Objects.requireNonNull(area, "Focus area cannot be null");
            return this.add(new Focus<K>(key, area));
        }

        @Contract(value="null -> fail; _ -> this")
        public Builder<K> addAll(Collection<Focus<K>> foci) {
            Objects.requireNonNull(foci, "Foci cannot be null");
            this.foci.addAll(foci);
            return this;
        }

        @Contract(value="-> new")
        public SimpleKeyedFocusModel<K> build() {
            return new SimpleKeyedFocusModel<K>(List.copyOf(this.foci));
        }
    }
}

